#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {320.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {320.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {320.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond7 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {320,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond9 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond10 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond11 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond12 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static DWORD Letters[1024], Letters2[1024];
static WORD Buff2[65536];

void LInit_Font()
{
	PrepareTextureFromArray(g_PicFlo1,256,256, &g_TextureFlo1);
}

void QInit_Font()
{
	DWORD Cpt1;

	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	//grTexFilterMode(GR_TMU0, GR_TEXTUREFILTER_POINT_SAMPLED, GR_TEXTUREFILTER_POINT_SAMPLED);

	g_TextureBuff.info.format = GR_TEXFMT_RGB_565;

	for(Cpt1=0;Cpt1<1024;Cpt1++)
	{
		Letters2[Cpt1] = Letters[Cpt1] = rand()%75;
	}

	DownloadTexture(&g_TextureFlo1);
}

void Effect_Font()
{
	DWORD Cpt1, Cpt2;
	DWORD Cpt3, Cpt4;
	static DWORD Old = 0;
	DWORD Rate;
	DWORD Transp;

	if (Old != (g_demostate.TickInEffect & 0xffffd0))
	{
		Old = g_demostate.TickInEffect & 0xffffd0;
		for(Cpt1=0;Cpt1<1024;Cpt1++)
		{
			Letters[Cpt1] = rand()%75;
			Letters2[Cpt1] = rand()%75;
		}

		for(Cpt1=0;Cpt1<256;Cpt1+=8)
		{
			for(Cpt2=0;Cpt2<32;Cpt2++)
			{
				for(Cpt3=0;Cpt3<8;Cpt3++)
				{
					for(Cpt4=0;Cpt4<8;Cpt4++)
					{
						DWORD CptTmp1 = Cpt3*600+Cpt4;

						((WORD*)g_FrameBuf3d)[(Cpt1+Cpt3)*256+Cpt2*8+Cpt4]
							= g_PicFont[CptTmp1+Letters[Cpt1+Cpt2]*8];
						Buff2[(Cpt1+Cpt3)*256+Cpt2*8+Cpt4]
							= g_PicFont[CptTmp1+Letters2[Cpt1+Cpt2]*8];
					}
				}
			}
		}

	}

	Rate = g_demostate.TickInEffect>>4;
	if (Rate<256)
		grConstantColorValue(Rate+(Rate<<8)+(Rate<<16));
	else
		grConstantColorValue(0xffffffff);

	g_TextureBuff.info.data = g_FrameBuf3d;
	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	SelectTexture(g_TextureBuff);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);	

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	g_TextureBuff.info.data = &Buff2[0];

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	
	grDrawTriangle(&Fond5, &Fond6, &Fond7);
	grDrawTriangle(&Fond7, &Fond8, &Fond5);

	SelectTexture(g_TextureFlo1);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, 
		GR_BLEND_ZERO, GR_BLEND_ZERO);
	Transp = (DWORD)(128+64.f*(float)cos(g_demostate.TickInEffect/200.f));
	grConstantColorValue(Transp<<24);

	grDrawTriangle(&Fond9, &Fond10, &Fond11);
	grDrawTriangle(&Fond11, &Fond12, &Fond9);
}

void ByeBye_Font()
{
	FreeTexture(&g_TextureFlo1);
	g_TextureBuff.info.data = g_FrameBuf3d;
}